classdef mySignalMaker
   methods (Static) 
       %% periodic signal by Spline
       
       function [fcn]=basedOnSin(dy, V1, V2, f)
           
           n = length(dy);
           aa = linspace(0, 2*pi, n+1);
           aa(end) = [];
           s  = sin(aa)*(V1-V2)/2+(V1+V2)/2;
           s  = s+dy;
           %fcn = mySignalMaker.periodSpline( s, 1/f,'mode','as_is','method','makima', 'show');
           fcn = mySignalMaker.periodSpline( s, 1/f,'mode','as_is','method','spline');
           
       end
       
       function [fcn]=periodSpline(y,period,varargin) %slo,mode) %,Period,n)
            tipi = ["slope" "mode" "showPlot" "method"];
            met  = ["makima" "spline" "linear" "pchip"];  %<-- opzioni di "method"
            opz  = ["as_is" "norm" "voltage" "rescaled"];  %<-- opzioni di "mode"
            slo = mean(diff(y([end 1 2]))); 
            mode = opz(1);   % mode  : default(as_is)
            mymet = met(2);  % method : default(spline)
            show=false;
            
           for i=1:2:length(varargin)
            t = validatestring(varargin{i},tipi);
            switch t
                case tipi(1)
                    slo  = varargin{i+1};
                case tipi(2)
                    mode = validatestring(varargin{i+1},opz);
                case tipi(3)
                    show = true;
                case tipi(4)
                    mymet = validatestring(varargin{i+1},met); 
            end
           end
           
           x = 1:length(y);
           k=period/length(x);
           %m=mean(y([1 end]));
           
           xx=1:0.001:x(end)+1;
           switch mymet
               case met(2) %(spline)
                spl = spline([x x(end)+1],[slo y y(1) slo],xx);
               otherwise
                spl = interp1([x x(end)+1],[y y(1)],xx,mymet);
           end
           A = 1; b=0;
           switch mode
               case opz(2) %'norm'
                  y   = trasforma(y,true);
                  spl = trasforma(spl,true);
                  
               case opz(3) %'voltage'
                  y = trasforma(y,true);
                  spl = trasforma(spl,true);
                  A=3.99; b=5.5;
               case opz(4) %'rescaled'
                  y = trasforma(y);
                  spl = trasforma(spl);
           end
           fcn= @(p) interp1((xx-1)*k,b+A*spl,mod(p,period),'linear');
           
           if show
            figure
            plot(  (xx-1)*k        ,b+A*spl     ,'-b'); hold on
            plot(([x x(end)+1]-1)*k,b+A*[y y(1)],'or','MarkerSize',5)
           end
           
           function y=trasforma(x,fondoscala)
               L1 = min(spl); L2=max(spl);
               if (nargin==2) && fondoscala
                   L1=min(L1,0);
                   L2=max(L2,1);
               end
               %y = rescale(x,0,1,'InputMin',L1,'InputMax',L2);
               y = (L1+x)/L2;
           end
       end
       
       %% timeFcn2VetSignal
       % Esempio di Utilizzo:
       % timeFcn2VetSignal( @(x) 3*x+1, 300, 4, 'initial', 1, 'delay', 2)
       % timeFcn2VetSignal( @(x) 4, 300, 4, 'initial', 1, 'delay', 2)
       % timeFcn2VetSignal( @(x) 4, 300, 4)
       
       % timeFcn2VetSignal( @(x) (x>1)+3.1*(x>3)+2.4*(x>4), 300, 10)
       % timeFcn2VetSignal( @(t) sin(3*2*pi*t-pi/2)+1, 300, 7, 'initial',0,'delay',2)
       
       % pi2 = 2*pi;
       % timeFcn2VetSignal( @(t) sin(pi2*1.25*t)*(-0.3)+sin(pi2*2.5*t)*2+7+sin(pi2*10*t)*0.5, 2000, 10)

       % timeFcn2VetSignal( @(x) 3*x, 300, 2, 'repeat', 10)
       % timeFcn2VetSignal( @(x) (x<1)+(x<.4)+(x<1.5), 300, 3, 'repeat', 7, 'del',1,'in',0)
        
       
       function [vety, vetx]=timeFcn2VetSignal( handl, freq, durata, varargin )
           initialValue = 5.5; %valore di default se c'è un delay.
           delay        = 0; %delay di default in secondi.
           showPlot     = true; % mostrare un plot ?
           repeatTill   = durata;
           
           for i=1:2:length(varargin)
               tipi = ["initialValue" "delay" "showPlot" "repeatTill"];
               v = validatestring(varargin{i}, tipi);
               switch v
                   case tipi(1)
                       initialValue = varargin{i+1};
                   case tipi(2)
                       delay = varargin{i+1};
                       if delay<0
                           warning('il delay dovrebbe essere positivo [s]')
                       end
                   case tipi(3)
                       showPlot = varargin{i+1};
                       
                   case tipi(4)
                       repeatTill = varargin{i+1};
               end
           end
           
           passo = 1/freq;
           
           vet.time = (0:passo:repeatTill)';
           vet.y    = handl( vet.time-delay);
           
           % se il function handle produce un solo valore anziché un vettore
           % lungo tanto quanto la timeline -> va riprodotto.
           if length(vet.y)<length(vet.time)
               if numel(vet.y)==1
                   vet.y = repmat(vet.y,size(vet.time));
               else
                   error('Function Handle not vectorized')
               end
           end
           
           vet.y(vet.time<delay) = initialValue;
           
           % se repeatTill è > durata.. il segnale ha una sua periodicità
           if repeatTill > durata
               firstIdx = find(vet.time>delay,1,'first');
               lastIdx  = find(vet.time<=durata+delay,1,'last');
               stampo  = vet.y( firstIdx:lastIdx );
               missing = length(vet.time)-lastIdx;
               finestra = lastIdx-firstIdx+1;
               vet.y = [vet.y(1:lastIdx);
                        repmat(stampo,fix( missing/finestra),1);
                        stampo(1:rem(missing, finestra))];
           else
               if repeatTill < durata
               warning('repeatTill should be larger than durata');
               end
           end
           vety = vet.y;
           vetx = vet.time;
           
           if showPlot
               figure
               plot(vet.time, vet.y,'-')
           end
       end
    %% isLengthOk
    % Esempio di Utilizzo:
    % Creare segnali con la stessa size(..,1).
    % [esito,s]=isLengthOk({(1:5)', (3:30)'},'keepLast')
    % [esito,s]=isLengthOk({(1:5)', (3:30)'},'close')
    % [esito,s]=isLengthOk({(1:5)', (1:5)'},'keepLast') %! attento deve essere matrice!

    function [esito,S]=isLengthOk(s,mode)
    esito = true;
    S = s;
    if iscell(s) && (length(s)>1)
        % mi aspetto che (s) sia un cell contenente (formule o array)

        % se tutti i segnali che ho sono degli array:
        if all(cellfun(@class,s, 'uniformoutput',false)=="double")
            sizes = cellfun(@(x) length(x), s);
            esito = all(sizes(1)==sizes);
            if ~esito
            warning('i canali sono di diversa lunghezza')
            MaxLen = max(cellfun('length',s));
            b = cellfun(@(x) [x; zeros(MaxLen-length(x),1)],s,'UniformOutput',false);
            S = [b{:}];
            tipi = ["closeValve" "keepLastValue"];
            mode = validatestring(mode, tipi);
            switch mode
                case tipi(1)
                    S(S==0) = 5.5;

                case tipi(2)
                    for i=1:length(s)
                        lastV = s{i}(end);
                        S(~S(:,i),i) =  lastV;
                    end
            end
            else
            S = cat(2,s{:});
            end
        end
    end
    end
    %% fillSignal
    % Creare un segnale per 3 canali.
    % S = fullChannel((1:50)', 2, {'copy',[2 3]})
    % S = fullChannel((1:50)', 1, {'copy'})
    % S = fullChannel((1:50)', [3], {'off'}) 
    % S = fullChannel((1:50)', [1 3], {'off'})
    
    function S = fullChannel(s,knownChannel,mode)
        sizeS = size(s,2);
        if sizeS>3
            warning('ho trovato più di 3 canali output!');
            warning('Controlla la formattazione del segnale');
            S = repmat(5.5,2,3); %per sicurezza spengo le valvole.
        elseif sizeS<3
            warning('ho trovato meno di 3 canali output!');
            
            %metto tutto a zero.
            S = repmat(5.5,size(s,1),3);
            k=0;
            for i=knownChannel
                k=k+1;
                k=min(k,size(s,2));
                S(:,i) = s(:,k);
            end
            
            mm = validatestring(mode{1},["copy" "off"]);
            switch mm
                case 'off'
                    %non faccio nulla, perché è già tutto a 5.5 (off-value)
                case 'copy'
                    if length(mode)<2 %se non specifico nulla, copio tutti il segnale su tutti i canali
                        S = repmat(s(:,1),1,3);
                    else
                        ctrlC = mode{2}(1); % <- l'indice del segnale che deve essere copiato
                        ctrlV = mode{2}(2); % <- l'indice del canale su cui deve essere copiato
                        S(:,ctrlV) = S(:,ctrlC);
                    end
            end
        else
            S = s;
        end
    end
    %% isVoltageOk
    % Verificare che il segnale sia tra [5.5 9.5].
    % esito = isVoltageOk(S)
    % esito = isVoltageOk(S,'Limits',[6 8],'Correct',true)
    
    function [esito,s]=isVoltageOk(s,varargin)
        correct = false;
        limits  = [5.5 9.5];
        safeEnd = true;
        tipi = ["limits" "correct" "safeEnd"];
        
        if nargin
           for i=1:2:length(varargin)
               v = validatestring(varargin{i},tipi);
               switch v
                   case tipi(1)
                       limits = varargin{i+1};
                   case tipi(2)
                       correct = varargin{i+1};
                   case tipi(3)
                       safeEnd = varargin{i+1}; 
               end
           end
        end
        
        esito = true;
        if any(s<limits(1),'all')
            %warning("alcuni valori sono inferiori a "+limits(1)+" Volt!")
            esito = false;
            if correct
               s(s<limits(1)) = limits(1); 
            end
        end
        
        if any(s>limits(2),'all')
            %warning("alcuni valori sono superiori a "+limits(2)+" Volt!")
            esito = false;
            if correct
               s(s>limits(2)) = limits(2); 
            end
        end
        
        if safeEnd
           s = cat(1,s,repmat(5.5,1,size(s,2))); 
        end
    end
    
    %% DominikFcn
    function [h, Inp] = DominikFcn(VmaxVet, VminVet, FreqVet)
        Inp = {VmaxVet,VminVet,FreqVet};
        maxL = max(cellfun(@numel, Inp));
        Inp = cellfun(@(v) repmat(v,1,maxL/length(v)), Inp, 'UniformOutput', false);
        Inp = cat(1, Inp{:}); %disp(Inp)
        
        pi2 = 2*pi;
        ss = @(x, Vm, VM, f) sin(x*pi2*f)*(VM-Vm)/2+(VM+Vm)/2;
        h  = @(x) ss(x, Inp(1), Inp(2), Inp(3));
        for j=2:size(Inp,2)
            new = @(x) ss(x, Inp(1,j), Inp(2,j), Inp(3,j));
            h = @(x) h(x)+new(x);
        end
    end
   end
end

%%